/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.animations;

import com.mlib.animations.InterpolationType;
import com.mlib.math.AnyPos;
import com.mojang.math.Vector3f;
import net.minecraft.util.Mth;

public abstract class Frame<Type> {
    final Type value;
    final InterpolationType interpolationType;

    public Frame(Type value, InterpolationType interpolationType) {
        this.value = value;
        this.interpolationType = interpolationType;
    }

    public Frame(Type value) {
        this(value, InterpolationType.LINEAR);
    }

    public abstract Type interpolate(float var1, Frame<Type> var2);

    public Type getValue() {
        return this.value;
    }

    public static class Vector
    extends Frame<Vector3f> {
        public Vector(Vector3f value, InterpolationType interpolationType) {
            super(value, interpolationType);
        }

        public Vector(Vector3f value) {
            super(value);
        }

        public Vector(float x, float y, float z, InterpolationType interpolationType) {
            this(new Vector3f(x, y, z), interpolationType);
        }

        public Vector(float x, float y, float z) {
            this(new Vector3f(x, y, z));
        }

        @Override
        public Vector3f interpolate(float ratio, Frame<Vector3f> nextFrame) {
            return AnyPos.from((Vector3f)this.getValue()).lerp(nextFrame.interpolationType.apply(ratio), nextFrame.getValue()).vec3f();
        }
    }

    public static class Degrees
    extends Value {
        public Degrees(float value, InterpolationType interpolationType) {
            super(value, interpolationType);
        }

        public Degrees(float value) {
            super(value);
        }

        @Override
        public Float getValue() {
            return Float.valueOf((float)Math.PI / 180 * ((Float)this.value).floatValue());
        }
    }

    public static class Value
    extends Frame<Float> {
        public Value(float value, InterpolationType interpolationType) {
            super(Float.valueOf(value), interpolationType);
        }

        public Value(float value) {
            super(Float.valueOf(value));
        }

        @Override
        public Float interpolate(float ratio, Frame<Float> nextFrame) {
            return Float.valueOf(Mth.m_14179_((float)nextFrame.interpolationType.apply(ratio), (float)((Float)this.getValue()).floatValue(), (float)nextFrame.getValue().floatValue()));
        }
    }
}

